function Results = VarCE_method(raster,times,params)
bin_width = params.bin_width;

% pre_church
spi_cell = cellfun(@(x) histcounts(x,...
    ((times(1) - bin_width/2):1:(times(end) + bin_width/2+10))),...
    raster,'UniformOutput',false);
spi_mat = cell2mat(spi_cell)';
times_temp = times -(times(1)-bin_width/2);%%%%% time - begining of time
sim.spikes = logical(spi_mat)';
sim.numtrials  = length(raster);
params.boxWidth = params.bin_width;

% compute
Result = compute_VarCE(sim,int64(times_temp),params);
Results.pre_church_varce_phi = params.conditional_FF;
Results.pre_church_varce = Result.VarCE;
Results.pre_church_varce_std = Result.VarCE_std_errors;
end